/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.util.List;
import java.util.regex.Pattern;
import mockit.coverage.CallPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListOfCallPoints {
    @NotNull
    private static final String EOL = System.getProperty("line.separator");
    private static final Pattern LESS_THAN_CHAR = Pattern.compile("<");
    @NotNull
    private final StringBuilder content = new StringBuilder(100);

    public void insertListOfCallPoints(@Nullable List<CallPoint> callPoints) {
        if (callPoints == null) {
            return;
        }
        if (this.content.length() == 0) {
            this.content.append(EOL).append("      ");
        }
        this.content.append("  <ol style='display:none'>").append(EOL);
        CallPoint currentCP = callPoints.get(0);
        this.appendTestMethod(currentCP.getStackTraceElement());
        this.appendRepetitionCountIfNeeded(currentCP);
        int n = callPoints.size();
        for (int i = 1; i < n; ++i) {
            CallPoint nextCP = callPoints.get(i);
            StackTraceElement ste = nextCP.getStackTraceElement();
            if (nextCP.isSameTestMethod(currentCP)) {
                this.content.append(", ").append(ste.getLineNumber());
            } else {
                this.content.append("</li>").append(EOL);
                this.appendTestMethod(ste);
            }
            this.appendRepetitionCountIfNeeded(nextCP);
            currentCP = nextCP;
        }
        this.content.append("</li>").append(EOL).append("        </ol>").append(EOL).append("      ");
    }

    private void appendTestMethod(@NotNull StackTraceElement current) {
        this.content.append("          <li>");
        this.content.append(current.getClassName()).append('#');
        this.content.append(LESS_THAN_CHAR.matcher(current.getMethodName()).replaceFirst("&lt;")).append(": ");
        this.content.append(current.getLineNumber());
    }

    private void appendRepetitionCountIfNeeded(@NotNull CallPoint callPoint) {
        int repetitionCount = callPoint.getRepetitionCount();
        if (repetitionCount > 0) {
            this.content.append('x').append(1 + repetitionCount);
        }
    }

    @NotNull
    public String getContents() {
        String result = this.content.toString();
        this.content.setLength(0);
        return result;
    }
}

